import uno

def evaluate_value(value_str):
    val = value_str.strip()

    if val == "":
        return "Die Zelle ist leer"

    try:
        num = float(val.replace(',', '.'))
        if num < 10:
            return "Wert kleiner 10"
        elif num >= 10 and num <= 100:                          #elif 10 <= num <= 100:
            return "Wert zwischen 10 und 100"
        else:
            return "Wert größer 100"
    except ValueError:
        return "Kein numerischer Wert"

def check_cell_value_to_right():
    doc = XSCRIPTCONTEXT.getDocument()
    selection = doc.getCurrentSelection()

    # Falls ein Zellbereich ausgewählt ist: erste Zelle nehmen
    if hasattr(selection, "getCellByPosition"):
        selection = selection.getCellByPosition(0, 0)

    # Prüfen, ob wirklich eine Zelle ausgewählt ist
    if not hasattr(selection, "getString"):
        return

    # Wert aus der ausgewählten Zelle lesen
    current_string = selection.getString()

    # Ergebnis berechnen
    result = evaluate_value(current_string)

    # Zielzelle: rechts daneben
    addr = selection.getCellAddress()          # enthält .Row und .Column
    sheet = selection.getSpreadsheet()         # das zugehörige Sheet
    target_col = addr.Column + 1               # eine Spalte nach rechts
    target_row = addr.Row

    # Optionaler Sicherheitscheck (nicht zwingend, aber nett)
    if target_col >= sheet.Columns.Count:
        return  # ganz rechts angekommen → nichts tun

    target_cell = sheet.getCellByPosition(target_col, target_row)
    target_cell.setString(result)

g_exportedScripts = (check_cell_value_to_right,)
