import uno
from com.sun.star.table.CellHoriJustify import CENTER

def process_with_autofit():
    doc = XSCRIPTCONTEXT.getDocument()
    selection = doc.getCurrentSelection()

    if not hasattr(selection, "getRangeAddress"):
        return

    addr = selection.getRangeAddress()
    sheet = selection.getSpreadsheet()
    
    counter = 1
    running_total = 0.0

    # Farben definieren
    COLOR_GREEN = 0xCCFFCC
    COLOR_RED = 0xFFCCCC
    COLOR_NONE = -1

    # 1. Daten verarbeiten
    for row_idx in range(addr.StartRow, addr.EndRow + 1):
        source_cell = sheet.getCellByPosition(addr.StartColumn, row_idx)
        index_cell = sheet.getCellByPosition(addr.StartColumn + 1, row_idx)
        sum_cell = sheet.getCellByPosition(addr.StartColumn + 2, row_idx)
        
        if source_cell.getType() == uno.Enum("com.sun.star.table.CellContentType", "VALUE"):
            val = source_cell.getValue()
            running_total += val
            
            index_cell.setValue(counter)
            sum_cell.setValue(running_total)
            
            index_cell.CellBackColor = COLOR_GREEN
            index_cell.HoriJustify = CENTER
            counter += 1
        else:
            index_cell.setString("Ignoriert")
            sum_cell.setString("-")
            index_cell.CellBackColor = COLOR_RED
            index_cell.HoriJustify = CENTER

    # 2. Spaltenbreite automatisch anpassen (AutoFit)
    # Wir greifen auf die Spalten-Container zu
    columns = sheet.getColumns()
    
    # Wir passen die Spalte für den Index (+1) und die Summe (+2) an
    idx_col_obj = columns.getByIndex(addr.StartColumn + 1)
    sum_col_obj = columns.getByIndex(addr.StartColumn + 2)
    
    # OptimalWidth auf True setzt die Breite passend zum Inhalt
    idx_col_obj.OptimalWidth = True
    sum_col_obj.OptimalWidth = True

g_exportedScripts = (process_with_autofit,)