def array_demo_with_stats(*args):
    doc = XSCRIPTCONTEXT.getDocument()
    sel = doc.getCurrentSelection()

    if not hasattr(sel, "getDataArray") or not hasattr(sel, "getRangeAddress"):
        return

    sheet = sel.getSpreadsheet()
    addr = sel.getRangeAddress()
    data = sel.getDataArray()

    # 1) Statistik über ALLE Zahlen im Bereich
    nums = [v for row in data for v in row if isinstance(v, (int, float))]
    if not nums:
        return

    mx, mn = max(nums), min(nums)
    avg = sum(nums) / len(nums)

    # 2) Pro Zeile einen Wert bilden (Zeilen-Mittelwert) -> passt in 1 Spalte
    row_means = []
    for row in data:
        rnums = [v for v in row if isinstance(v, (int, float))]
        row_means.append(sum(rnums) / len(rnums) if rnums else "")

    # 3) Spalte B (Diff) und C (Prozent) als 1-Spalten-Arrays (Tuple mit 1 Element)
    diff_col = tuple(((rm - avg) if isinstance(rm, (int, float)) else "",) for rm in row_means)
    perc_col = tuple(((((rm - avg) / avg) if isinstance(rm, (int, float)) and avg != 0 else ""),) for rm in row_means)

    sheet.getCellRangeByPosition(1, addr.StartRow, 1, addr.EndRow).setDataArray(diff_col)  # B
    sheet.getCellRangeByPosition(2, addr.StartRow, 2, addr.EndRow).setDataArray(perc_col)  # C

    # 4) Statistik-Block oben rechts (F1:G4)
    stat_col_label = 5  # F
    stat_col_value = 6  # G
    start_row = 0       # 1. Zeile

    sheet.getCellRangeByPosition(stat_col_label, start_row, stat_col_value, start_row + 3).clearContents(1023)

    # Bereich mit Blattname + A1-Notation (kurz)
    range_display = f"{sheet.Name}.{sel.AbsoluteName.split('.')[-1]}"

    stats = (
        ("Maximum", mx),
        ("Minimum", mn),
        ("Mittelwert", avg),
        ("Bereich", range_display)
    )

    for i, (label, val) in enumerate(stats):
        sheet.getCellByPosition(stat_col_label, start_row + i).setString(label)
        cell_v = sheet.getCellByPosition(stat_col_value, start_row + i)
        # Kürzer aber schwieriger zu verstehen: cell_v.setValue(val) if isinstance(val, (int, float)) else cell_v.setString(val)
        if isinstance(val, (int, float)):
            cell_v.setValue(val)
        else:
            cell_v.setString(val)
    # Optional: Prozent-Spalte C "irgendwie Prozent" (kann je nach System variieren)
    # perc_range = sheet.getCellRangeByPosition(2, addr.StartRow, 2, addr.EndRow)
    # perc_range.NumberFormat = 10


g_exportedScripts = (array_demo_with_stats,)
