import uno
from com.sun.star.awt.MessageBoxButtons import BUTTONS_OK
from com.sun.star.awt.MessageBoxType import INFOBOX


def analyze_selection_messagebox(*args):
    doc = XSCRIPTCONTEXT.getDocument()
    sel = doc.getCurrentSelection()

    # Nur Zellbereiche zulassen
    if not hasattr(sel, "getDataArray") or not hasattr(sel, "getRangeAddress"):
        return

    sheet = sel.getSpreadsheet()
    sheet_name = sheet.Name
    addr = sel.getRangeAddress()
    data = sel.getDataArray()

    # Alle Zahlen aus dem Bereich einsammeln
    nums = [v for row in data for v in row if isinstance(v, (int, float))]
    if not nums:
        msg = "Keine numerischen Werte im markierten Bereich gefunden."
        _show_msgbox(doc, "Auswertung", msg)
        return

    total = sum(nums)
    avg = total / len(nums)
    mn = min(nums)
    mx = max(nums)

    # Bereich als "Tabelle1.A1:C10" anzeigen
    # (AbsoluteName enthält i. d. R. bereits Blatt+Bbereich; wir normalisieren auf "Sheet.Range")
    range_part = sel.AbsoluteName.split(".")[-1]
    range_display = f"{sheet_name}.{range_part}"

    text = (
        "Auswertung des markierten Bereichs\n\n"
        f"Tabellenblatt: {sheet_name}\n"
        f"Bereich: {range_display}\n\n"
        f"Anzahl Zahlen: {len(nums)}\n"
        f"Summe: {total:.2f}\n"
        f"Mittelwert: {avg:.2f}\n"
        f"Minimum: {mn:.2f}\n"
        f"Maximum: {mx:.2f}"
    )

    _show_msgbox(doc, "Auswertung", text)


def _show_msgbox(doc, title, text):
    # MessageBox im aktiven Calc-Fenster anzeigen
    parent = doc.CurrentController.Frame.ContainerWindow
    ctx = XSCRIPTCONTEXT.getComponentContext()
    toolkit = ctx.getServiceManager().createInstanceWithContext("com.sun.star.awt.Toolkit", ctx)
    box = toolkit.createMessageBox(parent, INFOBOX, BUTTONS_OK, title, text)
    box.execute()


g_exportedScripts = (analyze_selection_messagebox,)
