import uno
from com.sun.star.util import Date as UnoDate

# --- HELFER-FUNKTION FÜR DIE MESSAGEBOX ---
def _show_message(message, title="Hinweis", message_type="info"):
    """
    Zeigt ein Popup-Fenster an.
    message_type: 'info', 'warning', 'error'
    """
    ctx = XSCRIPTCONTEXT.getComponentContext()
    sm = ctx.ServiceManager
    toolkit = sm.createInstanceWithContext("com.sun.star.awt.Toolkit", ctx)
    parent = XSCRIPTCONTEXT.getDocument().CurrentController.Frame.ContainerWindow
    
    # Mapping: 1=Info, 2=Warning, 3=Error
    type_map = {"info": 1, "warning": 2, "error": 3}
    box_type = type_map.get(message_type, 1)
    
    # Box erstellen und anzeigen
    msg_box = toolkit.createMessageBox(parent, box_type, 1, title, message)
    msg_box.execute()

# --- HAUPT-FUNKTION (VOM BUTTON AUFGERUFEN) ---
def ausgabe_speichern(event=None):
    """
    Liest das Formular aus, validiert die Eingaben 
    und speichert sie in das Blatt 'Daten'.
    """
    # 1. Dokument und Tabellenblätter holen
    doc = XSCRIPTCONTEXT.getDocument()
    sheet_daten = doc.Sheets.getByName("Daten")
    sheet_eingabe = doc.Sheets.getByName("Eingabe") # Oder ActiveSheet
    
    # 2. Zugriff auf das Formular (Container der Elemente)
    # event.Source ist der Button, Model.Parent ist das Formular
    formular = event.Source.Model.Parent
    
    
    # --- SCHRITT A: VALIDIERUNG (TÜRSTEHER) ---
    
    # Prüfung 1: Ist ein Name eingetragen?
    txt_name_ctrl = formular.getByName("txt_name")
    name = txt_name_ctrl.Text
    
    if not name or name.strip() == "":
        _show_message("Bitte gib einen Namen ein!", "Fehlende Eingabe", "error")
        return # Abbruch: Skript wird hier beendet
        
    # Prüfung 2: Ist der Betrag gültig?
    num_betrag_ctrl = formular.getByName("num_betrag")
    betrag = num_betrag_ctrl.Value
    
    if betrag <= 0:
        _show_message("Der Betrag muss größer als 0 sein!", "Ungültiger Betrag", "error")
        return # Abbruch
        

    # --- SCHRITT B: RESTLICHE DATEN AUSLESEN ---
    
   # 1. Auswahl (Listenfeld)
    try:
        lst_ctrl = formular.getByName("lst_auswahl")
        # WICHTIG: .CurrentValue statt .Text
        auswahl = lst_ctrl.CurrentValue
        
        # Manchmal gibt CurrentValue auch nichts zurück, wenn nichts gewählt wurde
        if not auswahl: 
            auswahl = "Sonstiges"
    except:
        auswahl = "-"
        
    # 2. Datum (Datumsfeld)
    try:
        raw_date = formular.getByName("date_datum").Date
        # Wenn leer, ist Jahr oft 0
        if raw_date.Year == 0:
            datum_str = "Kein Datum"
        else:
            # Formatieren: TT.MM.JJJJ
            datum_str = f"{raw_date.Day:02d}.{raw_date.Month:02d}.{raw_date.Year}"
    except:
        datum_str = "Fehler"
        
    # 3. Zahlart (Radio Buttons)
    # Wir prüfen nur den "Bar"-Button. Wenn der State 1 ist, ist es Bar.
    ist_bar = formular.getByName("opt_bar").State == 1
    zahlart = "Bar" if ist_bar else "Karte"
    
    # 4. Checkboxen (Markierfelder)
    # State 1 = Ja (Haken), State 0 = Nein
    chk_beleg = formular.getByName("chk_beleg")
    hat_beleg = "Ja" if chk_beleg.State == 1 else "Nein"
    
    chk_rabatt = formular.getByName("chk_rabatt")
    ist_rabatt = "Ja" if chk_rabatt.State == 1 else "Nein"


    # --- SCHRITT C: SPEICHERN IN TABELLE "DATEN" ---
    
    # Erste freie Zeile finden
    curs = sheet_daten.createCursor()
    curs.gotoEndOfUsedArea(False)
    neue_zeile = curs.RangeAddress.EndRow + 1
    
    # Daten in die Spalten schreiben (0=A, 1=B, etc.)
    sheet_daten.getCellByPosition(0, neue_zeile).String = datum_str
    sheet_daten.getCellByPosition(1, neue_zeile).String = name
    sheet_daten.getCellByPosition(2, neue_zeile).String = auswahl
    sheet_daten.getCellByPosition(3, neue_zeile).String = zahlart
    sheet_daten.getCellByPosition(4, neue_zeile).Value = betrag
    sheet_daten.getCellByPosition(5, neue_zeile).String = hat_beleg
    sheet_daten.getCellByPosition(6, neue_zeile).String = ist_rabatt


    # --- SCHRITT D: FEEDBACK GEBEN ---
    
    # Nachricht für Zelle A15 zusammenbauen
    # :.2f formatiert den Betrag auf 2 Nachkommastellen
    feedback_text = f"✅ Gespeichert: {name} - {auswahl} ({betrag:.2f} €)"
    
    sheet_eingabe.getCellRangeByName("A14").String = feedback_text


    # --- SCHRITT E: FORMULAR AUFRÄUMEN (RESET) ---
    
    # Textfelder leeren
    txt_name_ctrl.Text = ""
    
    # Zahlenfeld auf 0
    num_betrag_ctrl.Value = 0
    
    # Checkboxen Haken entfernen (State = 0)
    chk_beleg.State = 0
    chk_rabatt.State = 0
    
    # Optional: Radio Button wieder auf Bar setzen
    formular.getByName("opt_bar").State = 1

    # Liste mit der Auswahl zurücksetzen
    lst_ctrl = formular.getByName("lst_auswahl")
    lst_ctrl.SelectedItems = ()


    
    return None

g_exportedScripts = (ausgabe_speichern,)